/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.validacion;

import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.EstadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ProveedorContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ListenerValidacionModeloDialogo
implements PropertyChangeListener {
    private final InformacionValidable modeloDatos;
    private final DialogoBase dialogo;

    public ListenerValidacionModeloDialogo(InformacionValidable modeloDatos, DialogoBase dialogo) {
        this.modeloDatos = modeloDatos;
        this.dialogo = dialogo;
    }

    public ListenerValidacionModeloDialogo(InformacionValidableContexto modeloDatos, ContextoValidacion contexto, DialogoBase dialogo) {
        this(modeloDatos, dialogo);
        modeloDatos.setContextoValidacion(contexto);
    }

    public ListenerValidacionModeloDialogo(InformacionValidableContexto modeloDatos, ProveedorContextoValidacion proveedorContexto, DialogoBase dialogo) {
        this(modeloDatos, dialogo);
        modeloDatos.setProveedorContextoValidacion(proveedorContexto);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ResultadoValidacion resultado = this.modeloDatos.validar();
        boolean exitoso = resultado.esEstadoExitoso();
        if (exitoso) {
            this.ejecutarValidacionFinal(resultado);
            exitoso = resultado.esEstadoExitoso();
        }
        if (exitoso) {
            this.dialogo.setErrorMessage(null);
            this.dialogo.setMessage(null);
            this.dialogo.setDialogoCompleto(true);
            return;
        }
        if (resultado.getEstado() == EstadoValidacion.FALLIDO) {
            this.dialogo.setMessage(null);
            this.dialogo.setErrorMessage(resultado.getMensaje());
            this.dialogo.setDialogoCompleto(false);
        } else if (resultado.getEstado() == EstadoValidacion.ADVERTENCIA) {
            this.dialogo.setErrorMessage(null);
            this.dialogo.setMessage(resultado.getMensaje(), 2);
            this.dialogo.setDialogoCompleto(true);
        }
    }

    public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
    }
}

